import Utilities.visa_operations as vo
import Utilities.gui_creator as gc

root = gc.create_window(title='Data Sampler',
                        size='800x500')

control_box, right_frame = gc.create_frames(root)

resource_name = \
           'USB0::0x0957::0x0607::MY47022122::INSTR'

rm, dmm = vo.open_session(resource_name)

def perform_query():

    vo.status_config_srq(dmm)

    args = gc.get_dmm_control_args(var_list)
    command = vo.dmm_command_string(*args)

    vo.write_instrument(dmm, command)
    vo.dmm_start_acquisition(dmm, sync=True)
    vo.wait_for_srq(dmm)
    response = vo.read_instrument(dmm)
    response = response[:-1]
    stx.delete(1.0, 'end')
    stx.insert(1.0, response)

#    response = response.split(',')
#    numpy_array = np.genfromtxt(response, 
#                                delimiter=',')

    return


var_list = gc.create_dmm_control(control_box)

stx = gc.create_text_box(right_frame, 
                         label='Response',
                         char_width=55, lines=20)

btn = gc.action_button(control_box, label='Submit',
                       action=perform_query)

root.mainloop()

vo.close_session_srq(rm, dmm)

